package com.company.model;

import com.company.exceptions.InvalidDataException;

public class Enroll {
    private int grade;
    private Subject subject;
    private Student student;

    private boolean isRefNotNull(Object ptr) {
        if (ptr == null) {
            return false;
        }
        return true;
    }

    public Enroll(int grade, Subject subject, Student student) {
        this.setGrade(grade);
        this.setSubject(subject);
        this.setStudent(student);
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        if (grade >= 10) {
            this.grade = grade;
        } else {
            String msg = "Enroll: grade = " + grade;
            throw new InvalidDataException(msg);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        if (isRefNotNull(subject) == true) {
            this.subject = subject;
        } else {
            String msg = "Enroll: subject = NULL";
            throw new InvalidDataException(msg);
        }
    }

    public Student getStudent() {
        return this.student;
    }

    public void setStudent(Student student) {
        if (isRefNotNull(student) == true) {
            this.student = student;
        } else {
            String msg = "Enroll: student = NULL";
            throw new InvalidDataException(msg);
        }
    }

    public boolean isEqualTo(Enroll obj) {
        if (this.student.isEqualTo(obj.student) && this.subject.isEqualTo(obj.subject)) {
            return true;
        }
        return false;
    }
}
